/***************************************************************************

Author: Robert  Urbanczik
Call:  Y = unpackbit(A)
       C   : np by m uint32-Array
       Y   : m by 32*np logical-Array
Does:  Unpacks the bitmaps C(:,i) into Y(i,:)

***************************************************************************/

#include <math.h>
#include "mex.h"

/* Input Arguments */

#define	A_IN	prhs[0]
/* Output Arguments */

#define	YP_OUT	plhs[0]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned char  *yp,*ypp,*yppp; 
    unsigned int x,l,k,np,m,*A; 
    unsigned int d[2];
     const int *dimp;
    
    /* Check for proper number of arguments */
    
    if (nrhs != 1) { 
	mexErrMsgTxt("Two input arguments required."); 
    } else if (nlhs > 1) {
	mexErrMsgTxt("Too many output arguments."); 
    } 

    dimp =  mxGetDimensions(A_IN);
    np = dimp[0];
    m = dimp[1];    
  
    YP_OUT = mxCreateLogicalMatrix(m,32*np);
    
    /* Assign pointers to the various parameters */ 
    yp = mxGetData(YP_OUT);
    A = mxGetData(A_IN); 
        
    /* Do the actual computations  */
 
    for (l = 0; l < m; l++){
     ypp = yp;
     for (k = 0; k < np; k++) {
       x = *A;
       yppp = ypp;
       while (x != 0) { *yppp = x%2;  x = x/2; yppp +=m;}
       A++; ypp += 32*m;}
     yp++;}
    
}


