(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11717,        507]*)
(*NotebookOutlinePosition[     12378,        530]*)
(*  CellTagsIndexPosition[     12334,        526]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Computational Geometry with SNAmat
\
\>", "Title",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->16,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell["\<\
This tutorial describes functions which give a more direct access \
to the computational geometry routines in SNAmat than the ones described in \
Tutorial  1.  The presented material is rather technical and it is perhaps \
best to skip it, at least initially.\
\>", "Text",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell["\<\
Make sure you are in the SNA tutorials directory, before loading \
SNAmat.\
\>", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< "\<../mathcode/SNAmat.m\>"\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The routines described below carry out computations on a polyhedral convex \
cone ",
  StyleBox["C",
    FontWeight->"Bold"],
  ", given\nby two matrices ",
  StyleBox["Z",
    FontWeight->"Bold"],
  " and ",
  StyleBox["H ",
    FontWeight->"Bold"],
  " as the set of points ",
  StyleBox["x",
    FontWeight->"Bold"],
  " satisfying ",
  StyleBox[" Zx = 0",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Hx \[GreaterEqual] 0",
    FontWeight->"Bold"],
  ".\nFor example, let us assume"
}], "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{\(Z\  = \ {}\), ";", " ", 
      RowBox[{"H", "=", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", "1", "1"},
                {"1", "1", "0"},
                {"2", "3", "1"}
                }], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]]}], ";"}]], "Input"],

Cell["So there are no equality but only inequality constraints.", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "To compute a minimal generating set of  ",
  StyleBox["C",
    FontWeight->"Bold"],
  ", use:"
}], "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[BoxData[
    \(\({gset, rev}\  = \ ZH2gset[Z, H];\)\)], "Input"],

Cell[TextData[{
  "the result ",
  StyleBox["gset",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" ",
    FontSlant->"Plain"],
  "is a list of row vectors generating the cone:"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gset // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", \(-1\), "1"},
            {"0", "0", "1"},
            {"0", "1", \(-1\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The first ",
  StyleBox["rev",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox["  r",
    FontSlant->"Plain"],
  "ows in  ",
  StyleBox["gset",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" ",
    FontSlant->"Plain"],
  "are reversible.  Since"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rev\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["gset[[1]] ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" ",
    FontSlant->"Plain"],
  "is reversible, i.e. ",
  StyleBox["-gset[[1]]  ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " also lies in ",
  StyleBox[" ",
    FontSlant->"Plain"],
  StyleBox["C.",
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Some of the above claims are easy to verify.  Calculating\
\>", \
"Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(H . Transpose[gset]\ \  // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "1", "0"},
            {"0", "0", "1"},
            {"0", "1", "2"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "yields only non-negative values in the resulting matrix, showing that the \
rows of  ",
  StyleBox["gset",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" ",
    FontSlant->"Plain"],
  " indeed lie in ",
  StyleBox["C",
    FontWeight->"Bold"],
  " .  Further"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(H . gset[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "so  ",
  StyleBox["gset[[1]]",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " is indeed reversible. "
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
As a problem with equality constraints consider\
\>", \
"Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Znew\  = \ Take[gset, 1]; \ Hnew\  = \ Drop[gset, 1];\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(Hnew\\)\\\" is similar to existing symbol \\\
\"\\!\\(Znew\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell["So ", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Znew\  // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", \(-1\), "1"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "is the reversible row in   ",
  StyleBox["gset ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "and the other rows go into"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Hnew\  // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "0", "1"},
            {"0", "1", \(-1\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The cone given by ",
  StyleBox["Znew",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  " and ",
  StyleBox["Hnew ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "is pointed, since"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({gsetnew, revnew}\  = \ 
        ZH2gset[Znew, Hnew];\)\), "\[IndentingNewLine]", 
    \(\ revnew\)}], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell["and its edges are", "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gsetnew\  // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "1", "1"},
            {"1", "1", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Notice that these are just the first two rows of  ",
  StyleBox["H",
    FontWeight->"Bold"],
  ". This is a consequence of duality and the fact that the inequality given \
by that last row of ",
  StyleBox["H ",
    FontWeight->"Bold"],
  "is redundant. "
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "You can also use SNAmat to calculate  the elementary vectors of  ",
  StyleBox["C",
    FontWeight->"Bold"],
  ", using:"
}], "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({elvs, elvsrev}\  = \ ZH2elvs[Z, H];\)\ \), "\[IndentingNewLine]", 
    \(elvs\  // MatrixForm\)}], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", \(-1\), "1"},
            {"0", "0", "1"},
            {"0", "1", \(-1\)},
            {"1", "0", "0"},
            {\(-1\), "1", "0"},
            {"0", "1", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(elvsrev\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{670, 644},
WindowMargins->{{92, Automatic}, {Automatic, 21}},
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 235, 10, 65, "Title",
  Evaluatable->False],
Cell[1992, 63, 458, 12, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2475, 79, 282, 10, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2782, 93, 62, 1, 31, "Input"],
Cell[2847, 96, 89, 1, 23, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2985, 103, 636, 26, 89, "Subsubsection",
  Evaluatable->False],
Cell[3624, 131, 370, 10, 67, "Input"],
Cell[3997, 143, 180, 5, 30, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[4214, 153, 241, 10, 43, "Subsubsection",
  Evaluatable->False],
Cell[4458, 165, 69, 1, 31, "Input"],
Cell[4530, 168, 310, 13, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4865, 185, 51, 1, 31, "Input"],
Cell[4919, 188, 272, 8, 95, "Output"]
}, Open  ]],
Cell[5206, 199, 410, 19, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5641, 222, 36, 1, 31, "Input"],
Cell[5680, 225, 35, 1, 46, "Output"]
}, Open  ]],
Cell[5730, 229, 453, 20, 30, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[6220, 254, 199, 8, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6444, 266, 70, 1, 31, "Input"],
Cell[6517, 269, 266, 8, 95, "Output"]
}, Open  ]],
Cell[6798, 280, 412, 17, 45, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7235, 301, 50, 1, 31, "Input"],
Cell[7288, 304, 43, 1, 46, "Output"]
}, Open  ]],
Cell[7346, 308, 245, 11, 30, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[7628, 324, 189, 8, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7842, 336, 86, 1, 31, "Input"],
Cell[7931, 339, 356, 5, 39, "Message"]
}, Open  ]],
Cell[8302, 347, 126, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8453, 356, 53, 1, 31, "Input"],
Cell[8509, 359, 211, 6, 60, "Output"]
}, Open  ]],
Cell[8735, 368, 267, 11, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9027, 383, 53, 1, 31, "Input"],
Cell[9083, 386, 240, 7, 77, "Output"]
}, Open  ]],
Cell[9338, 396, 328, 15, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9691, 415, 134, 3, 47, "Input"],
Cell[9828, 420, 35, 1, 46, "Output"]
}, Open  ]],
Cell[9878, 424, 140, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10043, 433, 56, 1, 31, "Input"],
Cell[10102, 436, 237, 7, 77, "Output"]
}, Open  ]],
Cell[10354, 446, 394, 14, 45, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[10785, 465, 268, 10, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11078, 479, 131, 2, 47, "Input"],
Cell[11212, 483, 362, 11, 149, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11611, 499, 40, 1, 31, "Input"],
Cell[11654, 502, 35, 1, 46, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

