(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19349,        648]*)
(*NotebookOutlinePosition[     20031,        672]*)
(*  CellTagsIndexPosition[     19987,        668]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["Analyzing larger metabolic networks\n",
  FontSize->18,
  FontVariations->{"CompatibilityType"->0}]], "Title",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(<< "\<../mathcode/SNAsym.m\>";\)\)], "Input"],

Cell[BoxData[
    \(LinkObject["../mathcode/../pairelvs/pairelvsIFsh", 2, 2]\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The network", "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({name, 
          ecoli}\  = \ << \((SNApath <> "\<tutorials/ecoli.m\>")\);\)\), "\n\
", 
    \(name\)}], "Input"],

Cell[BoxData[
    \("Central carbon metabolism of Ecoli. \nAdapted from: Stelling et. al., \
Nature,420 (2002),190-193."\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(reactions@ecoli\  // Length\)], "Input"],

Cell[BoxData[
    \(99\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(metabolites@ecoli\)], "Input"],

Cell[BoxData[
    \({"2PG"\^"c", "3PG"\^"c", "AcCoA"\^"c", "AcP"\^"c", "Adh"\^"c", 
      "ADPGlc"\^"c", "Ala"\^"c", "alKG"\^"c", "Arg"\^"c", "Asn"\^"c", 
      "Asp"\^"c", "AspSAld"\^"c", "C14_0_FS"\^"c", "CDPEth"\^"c", 
      "Chor"\^"c", "Cit"\^"c", "CMP_KDO"\^"c", "Cys"\^"c", "dATP"\^"c", 
      "dCTP"\^"c", "dGTP"\^"c", "DHAP"\^"c", "di_am_pim"\^"c", "DPG"\^"c", 
      "dTTP"\^"c", "E4P"\^"c", "F16P"\^"c", "F6P"\^"c", "Fum"\^"c", 
      "G3P"\^"c", "G6P"\^"c", "Gln"\^"c", "Glu"\^"c", "Gly"\^"c", 
      "Glyc3P"\^"c", "Glyox"\^"c", "H_ex"\^"c", "His"\^"c", "HSer"\^"c", 
      "ICit"\^"c", "Ile"\^"c", "Leu"\^"c", "Lys"\^"c", "Mal"\^"c", 
      "Met"\^"c", "mit_FS"\^"c", "MTHF"\^"c", "NADH"\^"c", "NADPH"\^"c", 
      "NDPHep"\^"c", "OH_myr_ac"\^"c", "OxA"\^"c", "PEP"\^"c", "PGlac"\^"c", 
      "PGluc"\^"c", "Phe"\^"c", "Pro"\^"c", "PRPP"\^"c", "Pyr"\^"c", 
      "QuiH2"\^"c", "R5P"\^"c", "rATP"\^"c", "rCTP"\^"c", "rGTP"\^"c", 
      "Rl5P"\^"c", "rUTP"\^"c", "S"\^"c", "S7P"\^"c", "Ser"\^"c", 
      "SuccCoA"\^"c", "TDPGlcs"\^"c", "Thr"\^"c", "Trp"\^"c", "Tyr"\^"c", 
      "UDPGlc"\^"c", "UDP_NAG"\^"c", "UDP_NAM"\^"c", "Val"\^"c", "X5P"\^"c", 
      "Ac"\_Xt\%\("x"\), "CO2"\_Xt\%\("x"\), "Glyc"\_Xtin\%\("x"\), 
      "N"\_Xtin\%\("x"\), "O2"\_Xtin\%\("x"\), "Succ"\_Xtin\%\("x"\), 
      "ATP"\_Xtout\%\("x"\), "Biomass"\_Xtout\%\("x"\), 
      "Eth"\_Xtout\%\("x"\), "Form"\_Xtout\%\("x"\), 
      "Lac"\_Xtout\%\("x"\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox[" In contrast to the 110 reactions in the above reference, our \
network has only 99 reactions since the exchange reactions for the 10 \
external metabolites are not included here. Further , in the reference, ",
    FontVariations->{"CompatibilityType"->0}],
  Cell[BoxData[
      StyleBox[\("Ac"\_Xt\%\("x"\)\),
        FontWeight->"Bold"]]],
  " , has two irreversible exchange reactions instead of a single reversible \
one. 99+10+1 = 110."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Judging by the number of reactions, this network has about the same size \
as the one used in Tutorial 4. Indeed, due to the relatively few external \
metabolites the conversion cone is not more complicated and can be dealt with \
by the same techniques as in Tutorial 4.  So we shall only consider the flux \
cone, which is more complicated, probably due the fact that the E. Coli \
network has some lumped reactions and in effect correspond to a larger \
network.\nThe output of the function ",
  StyleBox["symfluxelvs ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "may use up a lot memory and we shall discuss how this can be controlled.\n\
",
  StyleBox["symfluxelvs ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "first adds the exchange reactions, then simplifies the network , and \
obtains the stoichiometry matrix, similarly to the following two commands"
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(secoli = fluxsimp[addexchanges[ecoli]]; {stoich, nrev} = 
      mnet2stoich[secoli];\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(secoli\\)\\\" is similar to existing symbol \
\\\"\\!\\(ecoli\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Then ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["symfluxelvs",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox[" calls the SNAmat routine ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["fluxelvs ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "to compute the elementary fluxes of the reduced network and, if you really \
need the  elementary fluxes,  this cannot be avoided. For ",
  StyleBox["secoli ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "the calculation is doable even on a moderately sized machine but may take \
5 to 10 minutes to complete. Hence, I suggest that you wait till your coffee \
break before evaluating the next two commands and, for the moment, proceed to \
the next section."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AbsoluteTiming[\ \({fluxese, reve}\  = \ 
          fluxelvs[stoich, nrev];\)]\)], "Input"],

Cell[BoxData[
    \({436.80276`9.091830367352413\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fluxese // Length\)], "Input"],

Cell[BoxData[
    \(507631\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "We shall make do with a minimal generating set for the flux cone of ",
  StyleBox["secoli.",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(\({fluxesg, revg}\  = \ 
        fluxgset[stoich, nrev];\)\[IndentingNewLine]
    fluxesg\  // Dimensions\)\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(fluxesg\\)\\\" is similar to existing symbol \
\\\"\\!\\(fluxese\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(revg\\)\\\" is similar to existing symbol \\\
\"\\!\\(reve\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \({1427, 46}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fluxesg\  // First\)], "Input"],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
      0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["We now have the flux vectors for the simplified network and would \
like  to relate them to the ones of the full network.  For this we need the \
tags of ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["secoli",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ",  since they keep track of the relationship. For instance,"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(with["\<Eth\>", trpairs@secoli]\  // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{\(R["AcCoA::Adh"]\), "+", \(R["Adh::Eth"]\), "+", 
              RowBox[{"Rx", "[", 
                RowBox[{\("Eth"\_Xtout\%\("x"\)\), 
                  StyleBox["\[RightVector]",
                    FontSize->18], "0"}], "]"}]}], 
            RowBox[{\("AcCoA"\^"c" + 2\ "NADH"\^"c"\), 
              StyleBox["\[RightVector]",
                FontSize->18], "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "shows that ",
  StyleBox["fluxsimp ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["has determined that in steady state the three reactions",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["R[AcCoA::Adh]",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" , ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["R[Adh::Eth]",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "  and ",
  StyleBox[" ",
    FontSize->12],
  Cell[BoxData[
      StyleBox[
        RowBox[{"Rx", "[", 
          RowBox[{\("Eth"\_Xtout\%\("x"\)\), 
            StyleBox["\[RightVector]",
              FontSize->18], "0"}], "]"}],
        FontWeight->"Bold",
        FontSlant->"Plain",
        FontTracking->"Plain",
        FontVariations->{"Underline"->False,
        "Outline"->False,
        "Shadow"->False,
        "StrikeThrough"->False,
        "Masked"->False,
        "CompatibilityType"->0,
        "RotationAngle"->0}]],
    FontSize->12],
  " ",
  StyleBox["must operate in conjunction and effectively become ",
    FontVariations->{"CompatibilityType"->0}],
  Cell[BoxData[
      StyleBox[\("AcCoA"\^"c" + 2\ "NADH"\^"c" \[RightVector] 0\),
        FontSize->12]],
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ". \nSometimes  ",
  StyleBox["fluxsimp ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "can make more ambitious simplification marked by the symbol",
  StyleBox[" ALT.  ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "These cases will be considered at the end of  Tutorial 8, here we just \
check that we don't have to worry about ",
  StyleBox["ALT",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(with[ALT, tags@secoli]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Since we have the fluxes of ",
  StyleBox["secoli ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "and the relationship between the reactions of ",
  StyleBox["secoli",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " and ",
  StyleBox["ecoli",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " given by ",
  StyleBox["tags@secoli",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " , it is very easy to obtain the fluxes of the full network using a matrix \
product."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ecolisymfluxesg\  = \ 
        fluxesg . \((tags@secoli)\)\ \  // 
          Expand;\)\), "\[IndentingNewLine]", 
    \(ecolisymfluxesg\  // First\)}], "Input"],

Cell[BoxData[
    \(R["Fum::Succ"] + R["Succ::Fum"]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ecolisymfluxesg ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "is essentially what we'd have obtained by just using  ",
  StyleBox["symfluxgset[ecoli],           ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "except that, in addition,  ",
  StyleBox["symfluxgset",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "  normalizes the result:"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(\(symfluxgset[ecoli] // First\) // First\),
      FontWeight->"Bold",
      FontSlant->"Plain",
      FontVariations->{"CompatibilityType"->0}]], "Input"],

Cell[BoxData[
    \(R["Fum::Succ"] + R["Succ::Fum"]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "But , using ",
  StyleBox["fluxesg  ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "and  ",
  StyleBox["tags@secoli, ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " we can make statements about the full network without explicitly \
computing  ",
  StyleBox["ecolisymfluxesg. ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "For instance to get the first flux of  ",
  StyleBox["ecolisymfluxesg ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "directly we could use:"
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fluxesg[\([1]\)] . \((tags@secoli)\)\ \  // Expand\)], "Input"],

Cell[BoxData[
    \(R["Fum::Succ"] + R["Succ::Fum"]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "As a more meaningful example, let us determine the average number of \
internal reactions per flux in the minimal generating set of  ",
  StyleBox["ecoli",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(counts = 
        Map[Count[# . \((tags@secoli)\)\  // Expand, R[_], \[Infinity]] &, 
          fluxesg];\)\), "\[IndentingNewLine]", 
    \(Plus @@ counts\ /Length[counts] // N\)}], "Input"],

Cell[BoxData[
    \(52.398037841625786`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"counts", "=", 
        RowBox[{"Map", "[", 
          RowBox[{\(Count[#, R[_], \[Infinity]] &\), ",", 
            StyleBox["ecolisymfluxesg",
              FontWeight->"Bold",
              FontSlant->"Plain",
              FontVariations->{"CompatibilityType"->0}]}], 
          StyleBox[" ",
            FontWeight->"Bold",
            FontSlant->"Plain",
            FontVariations->{"CompatibilityType"->0}], "]"}]}], 
      ";", \(Plus @@ counts\ /Length[counts] // N\)}]], "Input"],

Cell[BoxData[
    \(52.398037841625786`\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The first method is more complicated, slower but uses less memory than the \
second one because it does not need ",
  StyleBox["ecolisymfluxesg",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Text",
  Evaluatable->False,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "If your coffee break is over, and you have computed the full set ",
  StyleBox["fluxese ",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "of elementary vectors of\n",
  StyleBox["secoli",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  ",",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "you can determine the average number of internal reactions per elementary \
flux in ",
  StyleBox["ecoli      ",
    FontWeight->"Bold",
    FontSlant->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "by"
}], "Subsubsection",
  Evaluatable->False,
  TextJustification->1,
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(counts = 
        Map[Count[# . \((tags@secoli)\)\  // Expand, R[_], \[Infinity]] &, 
          fluxese];\)\), "\[IndentingNewLine]", 
    \(Plus @@ counts\ /Length[counts] // N\)}], "Input"],

Cell[BoxData[
    \(76.1311090142249`\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{669, 719},
WindowMargins->{{Automatic, 154}, {1, Automatic}},
ShowSelection->True,
StyleDefinitions -> "Demo.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 241, 7, 65, "Title",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2020, 62, 67, 1, 31, "Input"],
Cell[2090, 65, 89, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2216, 71, 211, 7, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2452, 82, 137, 4, 47, "Input"],
Cell[2592, 88, 134, 2, 62, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2763, 95, 60, 1, 31, "Input"],
Cell[2826, 98, 36, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2899, 104, 50, 1, 31, "Input"],
Cell[2952, 107, 1456, 21, 192, "Output"]
}, Open  ]],
Cell[4423, 131, 589, 15, 77, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[5049, 151, 1094, 25, 227, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6168, 180, 117, 2, 47, "Input"],
Cell[6288, 184, 359, 5, 39, "Message"]
}, Open  ]],
Cell[6662, 192, 998, 27, 90, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7685, 223, 111, 2, 31, "Input"],
Cell[7799, 227, 77, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7913, 233, 50, 1, 31, "Input"],
Cell[7966, 236, 40, 1, 46, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8055, 243, 401, 13, 43, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8481, 260, 152, 3, 47, "Input"],
Cell[8636, 265, 362, 5, 39, "Message"],
Cell[9001, 272, 356, 5, 39, "Message"],
Cell[9360, 279, 44, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9441, 285, 51, 1, 31, "Input"],
Cell[9495, 288, 186, 3, 62, "Output"]
}, Open  ]],
Cell[9696, 294, 530, 15, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10251, 313, 79, 1, 31, "Input"],
Cell[10333, 316, 641, 17, 47, "Output"]
}, Open  ]],
Cell[10989, 336, 2282, 75, 117, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13296, 415, 55, 1, 31, "Input"],
Cell[13354, 418, 36, 1, 46, "Output"]
}, Open  ]],
Cell[13405, 422, 806, 28, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14236, 454, 183, 4, 47, "Input"],
Cell[14422, 460, 65, 1, 46, "Output"]
}, Open  ]],
Cell[14502, 464, 643, 21, 45, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15170, 489, 183, 4, 31, "Input"],
Cell[15356, 495, 65, 1, 46, "Output"]
}, Open  ]],
Cell[15436, 499, 815, 28, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16276, 531, 83, 1, 31, "Input"],
Cell[16362, 534, 65, 1, 46, "Output"]
}, Open  ]],
Cell[16442, 538, 394, 13, 45, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16861, 555, 214, 4, 47, "Input"],
Cell[17078, 561, 53, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17168, 567, 530, 13, 47, "Input"],
Cell[17701, 582, 53, 1, 46, "Output"]
}, Open  ]],
Cell[17769, 586, 384, 13, 45, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[18190, 604, 838, 29, 89, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19053, 637, 214, 4, 47, "Input"],
Cell[19270, 643, 51, 1, 46, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

