%Given x and mu, compute Dist and labels
function [Dist,labels]=Kmean_label(x,mu)

Dist=0;
N=size(x,1);  %number of data points
D=size(x,2);  %Dimension
K=size(mu,1);  %K cluster

dist=zeros(N,K);
for(k=1:K)
    d=x-repmat(mu(k,:),[N,1]);
    dist(:,k)=sqrt(sum(d.*d,2));
    Dist=Dist+sum(dist(:,k));
end

labels=zeros(N,1);
for(i=1:N)
    [v,labels(i)]=min(dist(i,:));
end
