
%Spherical K-mean learner
%input: x, mu_initial
%output: mu, CH
function [mu,CH]=learnKmean(x,mu,minClusterSize);

maxIter=20;
dthresh=1e-3;
N=size(x,1);  %number of data points
D=size(x,2);  %Dimension
K=size(mu,1);  %K cluster


dold=0;
[dnew,labels]=Kmean_label(x,mu);

while(abs(dnew-dold)>dthresh)
    for(k=1:K)
        o=find(labels==k);
        if(length(o)>0)
            mu(k,:)=sum(x(o,:))/length(o);
        end
    end
    dold=dnew;
    [dnew,labels]=Kmean_label(x,mu);
    info=sprintf('D=%.5f, deltaD=%.6f',dnew,dnew-dold);
end

    %Restriction: number of elements has to be greater than minClusterSize
    %otherwise, recycle it.

%between cluster scatter
B=0;
%within cluster scatter
W=0;
globmean=mean(x);
for(k=1:K)
    delta=mu(k,:)-globmean;
    o=find(labels==k);
    nk=length(o);
    B=B+nk*sum(delta.*delta);
    
    delta=x(o,:)-repmat(mu(k,:),[nk 1]);
    W=W+sum(sum(delta.*delta,2));
end
denom=(W*(K-1));
if(denom>0)
    CH=B*(N-K)/denom;
else
    CH=0;
end

%If small clusters are found => Bad clustering, make CH=0;
for(k=1:K)
    o=find(labels==k);
    if(length(o)<minClusterSize)
        CH=0;
    end
end

%If clusters overlap too much => Bad clustering
if(K>1)
    for(k=1:K)
        deltam=mu-repmat(mu(k,:), [K 1]);
        distm=sort(sqrt(sum(deltam.*deltam,2)));
        if(distm(2)<.00001)
        CH=0;
        end
    end
end