%compute log probability for diagonal mixture Gaussian

function lpall=lp_mg(x,w,mu,var1)
%sigma is a covariance matrix
LZERO=1e-50;
N=size(x,1);  %number of data points
D=size(x,2);  %Dimension
K=size(mu,1);  %K cluster

lpc=zeros(N,K);
for(k=1:K)
    ptmp=mvnpdf(x,mu(k,:),eye(D)*diag(var1(k,:),0));
    o=find(ptmp>0);
    lptmp=ones(N,1)*LZERO;
    lptmp(o)=log(ptmp(o));
    lpc(:,k)=log(w(k))*ones(N,1)+lptmp;
end

lpall=0;
lp=ones(N,1)*LZERO;
for(i=1:N)
    for(k=1:K);
        lp(i)=LAdd(lp(i),lpc(i,k));
    end
    lpall=lpall+lp(i);
end