<?php

// UniGene DLST: Dynamic Local Storage Tool
// R. Hart (c) 2005 Rutgers, The State University
// rhart@rci.rutgers.edu

// index.php - web page interface, requires unigene.class.inc

// DLST is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// DLST is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

//set passed variables
$_GET['go']=(isset($_GET['go'])?$_GET['go']:false);

include("include/unigene.class.inc");

$ug = new UniGene();


$update=$ug->admin; // sets switch for admin access.  this will be replaced on future versions.

if(!($_GET['go'])){
	// default page
	$ug->page_head("UniGene Table Status","status",$update);

	// Display genome table
	$ug->genome_table($update);

	$ug->page_tail();
} else {
	// go command found
	echo "<!--Go is ".$_GET['go']."-->";  //debug output hidden in html comment

	switch ($_GET['go']){

		case "update":
		// User has selected a genome to download and parse
		$ug->page_head("Update/Load Stored UniGene Table","update",$update);
		
		// Determine if user authorized to update
		if($update){

			//retrieve passed genome selected for action
			$genome = (isset($_GET['genome'])?$_GET['genome']:false);

			if($genome){
				echo "<h2>Loading Genome: $genome </h2>".$ug->crlf;
				
				if($ug->get_data_file($genome)) {
					echo "<p>File downloaded from NCBI...</p>".$ug->crlf;
				} else {
					echo "<p>Error: No file downloaded from NCBI</p>".$ug->crlf;
				}
				
				echo "<p>Beginning to parse file into database...</p>".$ug->crlf;
				
				if($ug->parser($genome)) {
					echo "<p>Database loaded and local file deleted.</p>".$ug->crlf;
				} else {
					echo "<p>There was an error during parsing.</p>".$ug->crlf;
				}
				
			} else {
				echo "<p>No genome selected.</p>".$ug->crlf;
			}
		} else {
			echo "<p>You are not authorized to update/load genomes.</p>".$ug->crlf;
		}
		$ug->page_tail();
		break;

		case "refresh":
		// Refresh local table of UniGene genome builds
		$ug->page_head("UniGene Table Update from NCBI","refresh",$update);

		$ug->refresh_genome_table($update);

		$ug->page_tail();

		default:
	}
}
?>