//   Copyright   Oliver Blechert   2021   //

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "main_win.h"

#include "analyse_walking_win_pairend_result.h"

   char **sequence;
   char *pairend_fragments;
   char **fastq_sequence_01;
   char **fastq_sequence_02;
   int *fragment_per_loop;
   char *alignment;

   int loop_todisplay=8;
   int **fastq_fragment_loop;
   const int max_result_pairend_display=100; 
   extern char *text04="8";

   int *matrix_shift_to_primary;        
   int *sequence_order; 
   int *sequence_shift_order;      
   int *sequence_status_order;   
   int *sequence_maxmatch_order;  
   char *match_matrix;
   char *primary_matrix;
   char *primary_matrix_status;
   char *pairend_alignment; 
   int **matrix_primary;
   int **matrix_primary_status;
   int **matrix_match;
   int **fastq_fragment_loop_read01_position;
   int **fastq_fragment_loop_read02_position;
   int *fastq_number;
   int added_counter;
   const int max_result_display; 
   int *fastq_number_position;


int display_results() {
   int i;
   int i1;
   alignment=malloc((strlen(*sequence)+500)*1000* sizeof(char));  
      for (i=0;i<70;i++) {
         *(alignment+i)=' '; }
*(alignment+70)='\0'; 
   alignment=strcat(alignment, *sequence);


for (i=0;i<5;i++) {
         *(alignment+strlen(*sequence)+4+i)=' '; }
   for (i=0;i<max_result_display;i++) {
      if (i<added_counter){
         alignment=strcat (alignment, "\n");
         for (i1=0;i1<70-(*(fastq_number_position+i));i1++){                                                       // display aligned fragments 
            alignment=strcat(alignment, " "); }
         alignment=strcat (alignment, *(fastq_sequence_01+*(fastq_number+i))); 
         alignment=strcat (alignment, "\n");
         if (align_pairend (*(fastq_number+i))< (strlen(*sequence))-150 && align_pairend (*(fastq_number+i))!=0) {       // display align pair end
            for (i1=0;i1<94+align_pairend (*(fastq_number+i)); i1++){
               alignment=strcat(alignment, " "); } }
         else {
            for (i1=0;i1<400; i1++){
               alignment=strcat(alignment, " "); } }
         alignment=strcat (alignment, *(fastq_sequence_02+*(fastq_number+i))); } } 

return 0; } 


int matrix_pairend () { 

   int number_char=0;                                                                        
   pairend_fragments=(char*)malloc((max_result_pairend_display*1000) * sizeof(char));         
   *(pairend_fragments)='\0';                                                                 
   char sequence_number[10];                                                                 

   int i;
   int i1;
   int i2;
   int i3;
   int i4;
   int loops;
   int match;
   int loop_analysis;

   int match_counter=0;
   int value_highest=0;
   int order_counter=0;
   int x=0;
   int y=0;

   char *ptr01;
   loop_todisplay=strtol(text04, &ptr01, 10)-1;
   loop_analysis=loop_todisplay-1;
   loops=fragment_per_loop[loop_analysis];  
   
   pairend_alignment=malloc(fragment_per_loop[loop_analysis]*fragment_per_loop[loop_analysis]*10*sizeof(char));    
   *(pairend_alignment)='\0';

   matrix_shift_to_primary=malloc(fragment_per_loop[loop_todisplay-1]*sizeof(int));
   for (i=0;i<(fragment_per_loop[loop_todisplay-1]);i++) { 
      *(matrix_shift_to_primary+i)=0; }

   matrix_primary=malloc(fragment_per_loop[loop_analysis]*sizeof(int*));
   matrix_primary_status=malloc(fragment_per_loop[loop_analysis]*sizeof(int*));
   matrix_match=malloc(fragment_per_loop[loop_todisplay-1]*sizeof(int*));

   for (i=0;i<(fragment_per_loop[loop_analysis]);i++) {
      *(matrix_primary+i)=malloc(fragment_per_loop[loop_analysis]*sizeof(int)); 
      *(matrix_primary_status+i)=malloc(fragment_per_loop[loop_analysis]*sizeof(int));
      *(matrix_match+i)=malloc(fragment_per_loop[loop_analysis]*sizeof(int)); }

   for (i=0;i<(fragment_per_loop[loop_analysis]);i++) {                     
      for (i1=0;i1<(fragment_per_loop[loop_analysis]);i1++) {
         *(*(matrix_primary+i1)+i)=0;
         *(*(matrix_primary_status+i1)+i)=0; } }

   for (i=0;i<loops;i++) {                    //input data to primary matrix
      for (i1=0;i1<loops;i1++) {
         match=0;
         for (i2=0;i2<100;i2++) {
            for (i3=0; i3<25;i3++) { 
               if (*(*(fastq_sequence_02+fastq_fragment_loop[loop_analysis][i])+i3+80)==*(*(fastq_sequence_02+fastq_fragment_loop[loop_analysis][i1])+i3+i2)){match++; } 
               else {match=0;} } 
            if (match>=25) { *(*(matrix_primary_status+i1)+i)=1; *(*(matrix_primary+i1)+i)=i2-80; } } } }

   sequence_order=malloc(loops*sizeof(int));
   sequence_shift_order=malloc(loops*sizeof(int));
   sequence_status_order=malloc(loops*sizeof(int));
   sequence_maxmatch_order=malloc(loops*sizeof(int));

   for (i=0;i<loops;i++) { 
      *(sequence_order+i)=0;
      *(sequence_shift_order+i)=0;
      *(sequence_status_order+i)=0;
      *(sequence_maxmatch_order+i)=0; }

   for (i=0;i<loops;i++) {              //primary matrix to match matrix
      for (i1=0;i1<loops;i1++) {
         match_counter=0;
         for (i2=0;i2<loops;i2++) {
            if (*(*(matrix_primary_status+i2)+i)!=0 && *(*(matrix_primary_status+(i2))+(i1))!=0) {
               match_counter++; } }
         *(*(matrix_match+i1)+i)=match_counter; 
         if (match_counter>value_highest) {                      //sequence with most matches to other sequences
            value_highest=match_counter;
            x=i;
            y=i1; } } }

   order_counter=1;
   *(sequence_order+0)=x;                  //first value with the most matches
   *(sequence_shift_order+0)=0;
   *(sequence_status_order+0)=1;
   *(sequence_maxmatch_order+0)=value_highest;

   for (i=0;i<loops-2;i++) { 
      value_highest=0;
      for (i1=0;i1<loops-2;i1++) { 
         for (i2=0;i2<loops-2;i2++) {
            if (*(sequence_status_order+i2)<1 && *(sequence_status_order+i1)==1 && i1!=i2) {
               if (*(*(matrix_match+i1)+i2)>value_highest) { 
                  x=i1;
                  y=i2;
                  value_highest=*(*(matrix_match+y)+x); } } } }

   *(sequence_order+order_counter)=y;                //first value with the most matches

   if (*(*(matrix_primary_status+y)+x)==1) {
      *(sequence_shift_order+order_counter)=*(sequence_shift_order+*(matrix_shift_to_primary+x))-(*(*(matrix_primary+y)+x)); }
   else if (*(*(matrix_primary_status+x)+y)==1){
      *(sequence_shift_order+order_counter)=*(sequence_shift_order+*(matrix_shift_to_primary+x))+(*(*(matrix_primary+x)+y)); }

   *(sequence_status_order+y)=1;
   *(matrix_shift_to_primary+y)=order_counter;
   *(sequence_maxmatch_order+order_counter)=value_highest;
   order_counter++; }

   match_matrix=malloc(fragment_per_loop[loop_analysis]*fragment_per_loop[loop_analysis]*10*sizeof(char)); 
   *(match_matrix)='\0';
   primary_matrix=malloc(fragment_per_loop[loop_analysis]*fragment_per_loop[loop_analysis]*10*sizeof(char)); 
   *(primary_matrix)='\0';
   primary_matrix_status=malloc(fragment_per_loop[loop_analysis]*fragment_per_loop[loop_analysis]*10*sizeof(char)); 
   *(primary_matrix)='\0';

   for (i=0;i<fragment_per_loop[loop_todisplay-1];i++) {
      for (i1=0;i1<fragment_per_loop[loop_todisplay-1];i1++) {
         sprintf(sequence_number,"%d\t", *(*(matrix_match+i)+i1));
         match_matrix=strcat(match_matrix, sequence_number);
         match_matrix=strcat(match_matrix,"\t"); }
      match_matrix=strcat(match_matrix,"\n"); } 
      match_matrix=strcat(match_matrix,"\0");

   for (i=0;i<fragment_per_loop[loop_todisplay-1]-2;i++) {
      for (i1=0;i1<fragment_per_loop[loop_todisplay-1]-2;i1++) {
         if (*(*(matrix_primary_status+i)+i1)==1) {
         sprintf(sequence_number,"%d\t", *(*(matrix_primary+i)+i1)); }
          else {strcpy(sequence_number,"-\t"); }  
         primary_matrix=strcat(primary_matrix, sequence_number);
         primary_matrix=strcat(primary_matrix,"\t"); }
      primary_matrix=strcat(primary_matrix,"\n"); } 
      primary_matrix=strcat(primary_matrix,"\0");

   for (i=0;i<fragment_per_loop[loop_todisplay-1]-2;i++) {
      for (i1=0;i1<fragment_per_loop[loop_todisplay-1]-2;i1++) {
         sprintf(sequence_number,"%d\t", *(*(matrix_primary_status+i)+i1)); 
         primary_matrix_status=strcat(primary_matrix_status, sequence_number);
         primary_matrix_status=strcat(primary_matrix_status,"\t"); }
      primary_matrix_status=strcat(primary_matrix_status,"\n"); } 
      primary_matrix_status=strcat(primary_matrix_status,"\0");

   pairend_fragments=strcat(pairend_fragments,*sequence);
   pairend_fragments=strcat(pairend_fragments,"\n");
   for (i=0;i<fragment_per_loop[loop_todisplay-1]-1;i++) {
      if (*(sequence_maxmatch_order+*(matrix_shift_to_primary+i))>3  ){
         for (i1=0;i1<((*(sequence_shift_order+*(matrix_shift_to_primary+i)))+200);i1++) {
            pairend_fragments=strcat(pairend_fragments, " "); } 
         pairend_fragments=strcat(pairend_fragments, *(fastq_sequence_02+fastq_fragment_loop[loop_todisplay-1][i]));
         pairend_fragments=strcat(pairend_fragments,"\n"); } }
   pairend_fragments=strcat(pairend_fragments,"\0");

return 0; }

void pairend01_result_win (GtkWidget *widget, gpointer data) {

   GtkWidget *window;
   GtkWidget *box;
   GtkWidget *menubar;
   GtkWidget *filemenu;
   GtkWidget *file;

   GtkWidget *quit;
   GtkWidget *helpabout;
   GtkWidget *helpmenu;
   GtkWidget *help;
   GtkWidget *about;

   const char *text;

   GtkEntryBuffer *buffer;
   GtkWidget *entry;

   GtkWidget *sw;
   GtkTextIter start, end;
   GtkTextTag *tag;
   GtkWidget *view=NULL;
   GtkTextBuffer *buffer_entry;
   GtkWidget *frame;
   GtkWidget *bbox;

   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW (window), "YNGSBAC");
   gtk_window_set_default_size (GTK_WINDOW (window), 800, 300);

   sw = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 
   menubar = gtk_menu_bar_new();
   filemenu = gtk_menu_new();
   file = gtk_menu_item_new_with_label("File");
   quit = gtk_menu_item_new_with_label("Quit");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), filemenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), quit);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), file);

   g_signal_connect_swapped (quit, "activate", G_CALLBACK (gtk_widget_destroy), window);

   helpmenu = gtk_menu_new();
   helpabout = gtk_menu_item_new_with_label("Help");
   help = gtk_menu_item_new_with_label("Help");
   about = gtk_menu_item_new_with_label("About");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(helpabout), helpmenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), help);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), about);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), helpabout);

   box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
   gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, FALSE, 3);

   gtk_container_add (GTK_CONTAINER (window), sw);
   gtk_container_add (GTK_CONTAINER (sw), box);

   frame = gtk_frame_new ("Result");
   bbox = gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);

   gtk_container_set_border_width (GTK_CONTAINER (bbox), 5);
   gtk_container_add (GTK_CONTAINER (box), frame);
   gtk_container_add (GTK_CONTAINER (frame), bbox);
   gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_START);
   gtk_box_set_spacing (GTK_BOX (bbox), 40);

   buffer = gtk_entry_buffer_new (NULL, 0);
   entry = gtk_entry_new_with_buffer (buffer);

   gtk_entry_set_text (GTK_ENTRY (entry),"1");
   text=gtk_entry_get_text (GTK_ENTRY (entry));

   view = gtk_text_view_new_with_buffer ((GtkTextBuffer *)buffer);
   gtk_box_pack_start (GTK_BOX (box), view, 1, 1, 0);

   buffer_entry =  gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));

   gtk_text_buffer_set_text (buffer_entry, alignment, -1);

   tag=gtk_text_buffer_create_tag (buffer_entry, "Monospace", "family", "Monospace", NULL); 
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &start, 0);
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &end, -1);
   gtk_text_buffer_apply_tag (buffer_entry, tag, &start, &end); 
   gtk_window_set_title (GTK_WINDOW (window), "childwindow");
   gtk_window_set_default_size (GTK_WINDOW (window), 1600, 800);
   gtk_widget_show_all (window);

   gtk_widget_show_all (window); }


void pairend02_result_win (GtkWidget *widget, gpointer data) {

   GtkWidget *window;
   GtkWidget *box;
   GtkWidget *menubar;
   GtkWidget *filemenu;
   GtkWidget *file;

   GtkWidget *quit;
   GtkWidget *helpabout;
   GtkWidget *helpmenu;
   GtkWidget *help;
   GtkWidget *about;

   const char *text;

   GtkEntryBuffer *buffer;
   GtkWidget *entry;

   GtkWidget *sw;
   GtkTextIter start, end;
   GtkTextTag *tag;
   GtkWidget *view=NULL;
   GtkTextBuffer *buffer_entry;
   GtkWidget *frame;
   GtkWidget *bbox;

   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW (window), "YNGSBAC");
   gtk_window_set_default_size (GTK_WINDOW (window), 800, 300);

   sw = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 
   menubar = gtk_menu_bar_new();
   filemenu = gtk_menu_new();
   file = gtk_menu_item_new_with_label("File");
   quit = gtk_menu_item_new_with_label("Quit");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), filemenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), quit);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), file);

   g_signal_connect_swapped (quit, "activate", G_CALLBACK (gtk_widget_destroy), window);

   helpmenu = gtk_menu_new();
   helpabout = gtk_menu_item_new_with_label("Help");
   help = gtk_menu_item_new_with_label("Help");
   about = gtk_menu_item_new_with_label("About");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(helpabout), helpmenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), help);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), about);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), helpabout);

   box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
   gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, FALSE, 3);

   gtk_container_add (GTK_CONTAINER (window), sw);
   gtk_container_add (GTK_CONTAINER (sw), box);

   frame = gtk_frame_new ("Result");
   bbox = gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);

   gtk_container_set_border_width (GTK_CONTAINER (bbox), 5);
   gtk_container_add (GTK_CONTAINER (box), frame);
   gtk_container_add (GTK_CONTAINER (frame), bbox);
   gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_START);
   gtk_box_set_spacing (GTK_BOX (bbox), 40);

   buffer = gtk_entry_buffer_new (NULL, 0);
   entry = gtk_entry_new_with_buffer (buffer);

   gtk_entry_set_text (GTK_ENTRY (entry),"1");
   text=gtk_entry_get_text (GTK_ENTRY (entry));

   view = gtk_text_view_new_with_buffer ((GtkTextBuffer *)buffer);
   gtk_box_pack_start (GTK_BOX (box), view, 1, 1, 0);

   buffer_entry =  gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));

   gtk_text_buffer_set_text (buffer_entry, pairend_fragments, -1);

   tag=gtk_text_buffer_create_tag (buffer_entry, "Monospace", "family", "Monospace", NULL); 
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &start, 0);
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &end, -1);
   gtk_text_buffer_apply_tag (buffer_entry, tag, &start, &end); 
   gtk_window_set_title (GTK_WINDOW (window), "childwindow");
   gtk_window_set_default_size (GTK_WINDOW (window), 1600, 800);
   gtk_widget_show_all (window);

   gtk_widget_show_all (window); }


extern void call_analyse_pairend01_result() {

   display_results();
   pairend01_result_win(NULL, NULL); }

extern void call_analyse_pairend02_result() {

   matrix_pairend ();
   pairend02_result_win(NULL, NULL); }


